#!/usr/bin/awk -f
#
# CALC_DISTAZ distance and azimuth between pairs of points.
#           
#           Format of first four input lines:
#           LONGITUDE LATITUDE LONGITUDE LATITUDE 
#
#           Format output lines:
#           DIST   AZ
#           %8.3f  %8.3f
#
#
#======================================================================


# Set and initialize variables.

BEGIN { pi = 3.1415926536;
        ER = 6378.137;
	D  = 0; }

# Define an acos function
function acos(x) { return atan2(sqrt(1-x*x), x) } 

# degrees into radians conversion
# assumes a spherical Earth

{ lon1 = $1/180 * pi ; lat1 = $2/180 * pi ; lon2 = $3/180 * pi ; lat2 = $4/180 * pi ; }

{
insided=(sin(lat1)*sin(lat2))+(cos(lat1)*cos(lat2)*cos(lon1-lon2))
d = acos(insided)*ER

above=sin(lon2-lon1)*cos(lat2)
below=(cos(lat1)*sin(lat2)) - (sin(lat1)*cos(lat2)*cos(lon2-lon1))

radaz=atan2(above, below)
#Give azimuth back in degrees
azim= radaz*(180/pi)

   printf("%8.3f %8.3f %s %s %s %s\n",d,azim,$5,$6,$7,$8);
   }

